<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AdminController extends Controller
{

    public function index()
    {
        return view('backend/login');
    }

    public function auth(Request $request)
    {
        $data = array(
            'email' => $request->email,
            'password' => $request->password
        );
        $query = Admin::where('email',$request->email)->get();
        if (isset($query[0])) {
            if (Hash::check($request->password, $query[0]->password)) {
                $request->session()->put('ADMIN_LOGIN', true);
                return redirect('admin/dashboard');
            } else {
                return back()->with(['msg'=>'Invalid username or password']);
            }
        } else {
            return back()->with(['msg'=>'Invalid username or password']);
        }
    }

    public function dashboard(){
        $count['sliders_count'] = DB::table('sliders')->select('id')->count();
        $count['plannings_count'] = DB::table('plannings')->select('id')->count();
        $count['products_count'] = DB::table('products')->select('id')->count();
        $count['contacts_count'] = DB::table('contacts')->select('id')->count();
        return view('backend/index', $count);
    }

}
