<?php

namespace App\Http\Controllers;

use App\Models\Team;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Storage;

class TeamController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id='')
    {
        if($id>0){
            $arr=Team::where(['id'=>$id])->get();
            $result['type']=$arr['0']->type;
            $result['name']=$arr['0']->name;
            $result['post']=$arr['0']->post;
            // $result['descr']=$arr['0']->descr;
            $result['image']=$arr['0']->image;

            $result['id']=$arr['0']->id;

        }else {
            $result['type']='';
            $result['name']='';
            $result['post']='';
            // $result['descr']='';
            $result['image']='';

            $result['id']='';

        }
        
        return view('backend/team_add',$result);
    }

    public function manage_team_process(Request $request)
    {

        if ($request->post('id')>0) {
            $image_validation="mimes:jpg,jpeg,png";
        }else {
            $image_validation="required|mimes:jpg,jpeg,png";
        }

        $request->validate([
            'name'=>'required',
            'image'=>$image_validation,
        ]);
        
        
        if ($request->post('id')>0) {
            $model=Team::find($request->post('id'));
            $msg="Team updated successfully";
        }else {
            $model=new Team();
            $msg="Team added successfully";
        }

        if ($request->hasfile('image')) {
            if ($request->post('id')>0) {
                $arrImage=DB::table('teams')->where(['id'=>$request->post('id')])->get();
                if (Storage::exists('/public/media/team/'.$arrImage[0]->image)) {
                    Storage::delete('/public/media/team/'.$arrImage[0]->image);
                }
            }

            $image=$request->file('image');
            $ext=$image->extension();
            $image_name=time().rand().'.'.$ext;
            $image->storeAs('./public/media/team', $image_name);
            $model->image=$image_name;
        }
        
        $model->type=$request->type;
        $model->name=$request->name;
        $model->post=$request->post;
        // $model->descr=$request->descr;
        $model->save();
        if ($model->save()) {
            return redirect()->route('teams')->with(['msg'=>$msg]);
        }else {
            return back()->with(['msg'=>'Something went wrong']);
        }
    }

    public function show(Team $team)
    {
        $data['teams'] = Team::all();

        return view('backend/team', $data);
    }

    public function delete(Request $request){
        $id = $request->id;
        $query = Team::find($id)->delete();
        if ($query) {
            return back()->with(['msg'=>'Team deleted successfully']);
        } else {
            return back()->with(['msg'=>'Something went wrong']);
        }
        
    }
}
