@extends('backend/layouts/layout')
@section('container')
@section('contact_select', 'active')
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Contacts</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item">Contacts</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
      @if(session()->has('msg'))
          <div class="alert alert-success" role="alert">
            {{session('msg')}}
          </div>
        @endif
        <!-- Small boxes (Stat box) -->
        <div class="row">
        <div class="col-12">


<div class="card">

  <div class="card-body">
    <table id="example1" class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>Sl no</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>DOB</th>
            <th>Budget</th>
            <th>Planning</th>
            <th>Message</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
      @foreach($contacts as $list)
        <tr>
            <td>{{$list->id}}</td>
            <td>{{$list->fnm.' '.$list->lnm}}</td>
            <td>{{$list->email}}</td>
            <td>{{$list->phone}}</td>
            <td>{{$list->dob}}</td>
            <td>{{$list->budget}}</td>
            <td>{{$list->planning}}</td>
            <td>{{$list->descr}}</td>
            <td>
                <a onclick="return cnf()" href="{{route('contact_delete')}}/{{$list->id}}">
                <i class="fa-regular fa-trash-can" style="color:red;"></i></a>
            </td>
        </tr>
      @endforeach
    </tbody>
    </table>
  </div>
  <!-- /.card-body -->
</div>
<!-- /.card -->
</div>
<!-- /.col -->
        </div>
        <!-- /.row -->
        <!-- Main row -->
       
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  @endsection