@extends('frontend/layouts/layout')
@section('title', 'About-Us')
@section('about_page_active', 'active')
@section('container')

        <!-- ========== BANNER SECTION START ========== -->
        <section class="banner-section position-relative">
            <div class="container">
                <h2 class="position-absolute top-50 text-white fw-bold">ABOUT US</h2>
            </div>
        </section>
        <!-- ========== /BANNER SECTION END ========== -->

        <!-- ======= about section start ======= -->
        <section class="about-section py-5">
            <div class="container">
                @php
                    $i=1;
                @endphp
                @foreach($abouts as $list)
                @php
                    $i++;
                    if ($i%2==0) {
                        $order='';
                    } else {
                        $order='order-md-1';
                    }
                @endphp
                <div class="row py-md-5 mb-4 mb-md-0">
                    <div class="col-md-7 {{$order}}">
                        <img class="d-block mx-auto mb-3" src="{{asset('frontend/img/cfp-cm-logo.jpg')}}" alt="">
                        <p class="lh-lg">
                            @php
                                echo $list->descr;
                            @endphp
                        </p>
                    </div>
                    <div class="col-md-5">
                        <img class="img-fluid rounded border border-5 border-primary" src="{{asset('storage/media/'.$list->image)}}" alt="">
                    </div>
                </div>
                @endforeach
            </div>
        </section>
        <!-- ======= /about section end ======= -->

        <!-- ======== home plan section start ======= -->
        <section class="home-plan-section py-5 bg-body-tertiary">
            <div class="container">
              <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">What We Do ?</h2>
              <div class="row row-cols-1 row-cols-md-3 row-gap-5">
                @php
                  $num=0;
                @endphp
                @foreach ($plannings as $list)
                @php
                  $num++;
                  if ($num<10) {
                    $num='0'.$num;
                  }
                @endphp
                <div class="col">
                  <div class="card border-0 rounded-4 py-4 px-2 wow zoomIn">
                    <div class="card-body">
                      <span class="number h1 text-white">{{$num}}</span>
                      <h5 class="fw-semibold my-4">{{$list->title}}</h5>
                      <p class="border-start border-primary border-2 ps-3 text-dark-emphasis fw-semibold mb-5">
                        {{$list->short_descr}}
                      </p>
                      <a class="text-primary fw-semibold" href="/goals">+ Read More</a>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
        </section>
        <!-- ======== /home plan section end ======= -->

        <section class="py-5" style="background-image:linear-gradient(rgb(8,95,126),rgba(0, 0, 0, 0.8)), url({{asset('frontend/img/clean_home_office_1200x1200.webp')}});background-attachment: fixed;">
            <div class="container">
                <h3 class="text-center my-5 text-white">It's All About Planning, which will help you to gain wealth</h3>
            </div>
        </section>

        <!-- ======== home plan section start ======= -->
        <section class="home-plan-section py-5 bg-body-tertiary">
            <div class="container">
              <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">Your Life with Nibedeeta INVESTMENT</h2>
              <div class="row row-cols-1 row-cols-md-3 row-gap-5 justify-content-center">
                @php
                  $num=0;
                @endphp
                @foreach ($products as $list)
                @php
                  $num++;
                  if ($num<10) {
                    $num='0'.$num;
                  }
                @endphp
                <div class="col">
                  <div class="card border-0 rounded-4 py-4 px-2 wow zoomIn">
                    <div class="card-body">
                      <span class="number h1 text-white">{{$num}}</span>
                      <h5 class="fw-semibold my-4">{{$list->title}}</h5>
                      <p class="border-start border-primary border-2 ps-3 text-dark-emphasis fw-semibold mb-5">
                        {{$list->short_descr}}
                      </p>
                      <a class="text-primary fw-semibold" href="/goals">+ Read More</a>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
        </section>
        <!-- ======== /home plan section end ======= -->


@endsection