@extends('frontend/layouts/layout')
@section('title', 'Contact-Us')
@section('contact_page_active', 'bg-primary text-white')
@section('container')

        <!-- ========== BANNER SECTION START ========== -->
        <section class="banner-section position-relative">
            <div class="container">
                <h2 class="position-absolute top-50 text-white fw-bold">CONTACT US</h2>
            </div>
        </section>
        <!-- ========== /BANNER SECTION END ========== -->

        <!-- ======== contact section start ======== -->
        <section class="contact-section py-5">
            <div class="container">
                <div class="row row-gap-3">
                    <div class="col-md-4">
                        <div class="card text-center border-0 py-4">
                            <div class="card-body">
                                <div class="icon bg-primary d-inline-block fs-2 text-white">
                                    <i class="fa-solid fa-phone fa-beat-fade"></i>
                                </div>
                                <h5 class="my-4 text-primary fw-semibold">Contact Number</h5>
                                <a class="text-dark fs-5" href="tel:{{$webinfo[0]->phone}}">{{$webinfo[0]->phone}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-center border-0 py-4">
                            <div class="card-body">
                                <div class="icon bg-primary d-inline-block fs-2 text-white">
                                  <i class="fa-regular fa-envelope-open fa-beat-fade"></i>
                                </div>
                                <h5 class="my-4 text-primary fw-semibold">Email ID</h5>
                                <a class="text-dark fs-5" href="mailto:{{$webinfo[0]->email}}">{{$webinfo[0]->email}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-center border-0 py-4">
                            <div class="card-body">
                                <div class="icon bg-primary d-inline-block fs-2 text-white">
                                  <i class="fa-solid fa-location-dot fa-beat-fade"></i>
                                </div>
                                <h5 class="my-4 text-primary fw-semibold">Office Address</h5>
                                <a class="text-dark fs-5" href="#">{{$webinfo[0]->address}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ======== /contact section end ======== -->

        <!-- ======== form section start ======== -->
        <section class="py-5">
          <div class="container">
            <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">Get In Touch</h2>
            <div class="row justify-content-center">
              <div class="col-md-8">
                @if(session()->has('msg'))
                <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
                  <strong>{{session('msg')}}</strong>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                <form class="form" action="{{route('manage_contact_process')}}" method="post">
                  @csrf
                  <div class="row">
                    <div class="col-md-6 mb-4">
                      <label class="form-label fw-semibold" for="">Your Name</label>
                      <input class="form-control" name="fnm" type="text" placeholder="First Name" required>
                    </div>
                    <div class="col-md-6 mb-4">
                      <label class="form-label fw-semibold opacity-0" for="">Your Name</label>
                      <input class="form-control" name="lnm" type="text" placeholder="Last Name" required>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-6 mb-4">
                      <label class="form-label fw-semibold" for="">Email ID</label>
                      <input class="form-control" name="email" type="email" placeholder="Your Email ID" required>
                    </div>
                    <div class="col-md-6 mb-4">
                      <label class="form-label fw-semibold" for="">Phone No.</label>
                      <input class="form-control" name="phone" type="text" placeholder="Phone Number" required>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-6 mb-4">
                      <label class="form-label fw-semibold" for="">Date of Birth</label>
                      <input class="form-control" name="dob" type="date" placeholder="" required>
                    </div>
                    <div class="col-md-6 mb-4">
                      <label class="form-label fw-semibold" for="">Monthly Savings Budget</label>
                      <input class="form-control" name="budget" type="text" placeholder="Phone Number" required>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12 mb-4">
                      <label class="form-label fw-semibold" for="">Interest for Planning</label>
                      <select class="form-select" name="planning" id="" required>
                        @foreach ($plannings as $list)
                        <option value="{{$list->title}}">{{$list->title}}</option>
                        @endforeach
                      </select>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12 mb-4">
                      <textarea class="form-control" name="descr" id="" rows="7" placeholder="Enter your message here..." required></textarea>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12">
                      <button class="btn btn-primary w-100 rounded-0" type="submit">Submit</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </section>
        <!-- ======== /form section end ======== -->

@endsection