<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MailController;

// BACKEND CONTROLLERS
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\ContentController;
use App\Http\Controllers\PlanningController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SeoController;
use App\Http\Controllers\CertificateController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\AboutController;
use App\Http\Controllers\WebInfoController;


// FRONTEND CONTROLLERS
use App\Http\Controllers\frontend\FrontendController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

// FRONTEND ROUTES
Route::get('/', [FrontendController::class, 'index']);
Route::get('/services', [FrontendController::class, 'services']);
Route::get('/products', [FrontendController::class, 'products']);
Route::get('/events/{slug?}', [FrontendController::class, 'events']);
Route::get('/news/{slug?}', [FrontendController::class, 'news']);
Route::get('/teams', [FrontendController::class, 'teams']);
Route::get('/certificates', [FrontendController::class, 'certificates']);
Route::get('/contact', [FrontendController::class, 'contact']);
Route::get('/about', [FrontendController::class, 'about']);

Route::post('/contact', [ContactController::class, 'manage_contact_process'])->name('manage_contact_process');




// BACKEND ROUTES
Route::get('admin', [AdminController::class, 'index']);
Route::post('admin/auth', [AdminController::class, 'auth'])->name('admin.auth');

Route::group(['middleware'=>'admin_auth'], function(){

    Route::get('admin/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');

    Route::get('admin/sliders', [SliderController::class, 'show'])->name('sliders');
    Route::get('admin/slider/add', [SliderController::class, 'index'])->name('slider_insert');
    Route::get('admin/slider/edit/{id?}', [SliderController::class, 'index'])->name('slider_edit');    
    Route::post('admin/slider/add', [SliderController::class, 'manage_slider_process'])->name('manage_slider_process');
    Route::get('admin/sliders/delete/{id?}', [SliderController::class, 'delete'])->name('slider_delete');
    Route::get('admin/sliders/stutas/{stutas?}/{id?}', [SliderController::class, 'stutas'])->name('slider_stutas');

    Route::get('admin/home-contents', [ContentController::class, 'show'])->name('home_contents');
    Route::get('admin/home-contents/add', [ContentController::class, 'index'])->name('home_content_insert');
    Route::get('admin/home-contents/edit/{id?}', [ContentController::class, 'index'])->name('home_content_edit');    
    Route::post('admin/home-contents/add', [ContentController::class, 'manage_home_content_process'])->name('manage_home_content_process');
    Route::get('admin/home-contents/delete/{id?}', [ContentController::class, 'delete'])->name('home_content_delete');
    Route::get('admin/home-contents/stutas/{stutas?}/{id?}', [ContentController::class, 'stutas'])->name('home_content_stutas');

    Route::get('admin/plannings', [PlanningController::class, 'show'])->name('plannings');
    Route::get('admin/plannings/add', [PlanningController::class, 'index'])->name('planning_insert');
    Route::get('admin/plannings/edit/{id?}', [PlanningController::class, 'index'])->name('planning_edit');    
    Route::post('admin/plannings/add', [PlanningController::class, 'manage_planning_process'])->name('manage_planning_process');
    Route::get('admin/plannings/delete/{id?}', [PlanningController::class, 'delete'])->name('planning_delete');
    
    Route::get('admin/products', [ProductController::class, 'show'])->name('products');
    Route::get('admin/products/add', [ProductController::class, 'index'])->name('product_insert');
    Route::get('admin/products/edit/{id?}', [ProductController::class, 'index'])->name('product_edit');    
    Route::post('admin/products/add', [ProductController::class, 'manage_product_process'])->name('manage_product_process');
    Route::get('admin/products/delete/{id?}', [ProductController::class, 'delete'])->name('product_delete');

    Route::get('admin/certificates', [CertificateController::class, 'show'])->name('certificates');
    Route::get('admin/certificate/add', [CertificateController::class, 'index'])->name('certificate_insert');
    Route::get('admin/certificate/edit/{id?}', [CertificateController::class, 'index'])->name('certificate_edit');    
    Route::post('admin/certificate/add', [CertificateController::class, 'manage_certificate_process'])->name('manage_certificate_process');
    Route::get('admin/certificates/delete/{id?}', [CertificateController::class, 'delete'])->name('certificate_delete');
    
    Route::get('admin/testimonials', [TestimonialController::class, 'show'])->name('testimonials');
    Route::get('admin/testimonials/add', [TestimonialController::class, 'index'])->name('testimonial_insert');
    Route::get('admin/testimonials/edit/{id?}', [TestimonialController::class, 'index'])->name('testimonial_edit');    
    Route::post('admin/testimonials/add', [TestimonialController::class, 'manage_testimonial_process'])->name('manage_testimonial_process');
    Route::get('admin/testimonials/delete/{id?}', [TestimonialController::class, 'delete'])->name('testimonial_delete');

    Route::get('admin/teams', [TeamController::class, 'show'])->name('teams');
    Route::get('admin/teams/add', [TeamController::class, 'index'])->name('team_insert');
    Route::get('admin/teams/edit/{id?}', [TeamController::class, 'index'])->name('team_edit');    
    Route::post('admin/teams/add', [TeamController::class, 'manage_team_process'])->name('manage_team_process');
    Route::get('admin/teams/delete/{id?}', [TeamController::class, 'delete'])->name('team_delete');
    
    Route::get('admin/abouts', [AboutController::class, 'show'])->name('abouts');
    Route::get('admin/abouts/add', [AboutController::class, 'index'])->name('about_insert');
    Route::get('admin/abouts/edit/{id?}', [AboutController::class, 'index'])->name('about_edit');    
    Route::post('admin/abouts/add', [AboutController::class, 'manage_about_process'])->name('manage_about_process');
    Route::get('admin/abouts/delete/{id?}', [AboutController::class, 'delete'])->name('about_delete');

    Route::get('admin/contacts', [ContactController::class, 'show'])->name('contacts');
    Route::get('admin/contacts/delete/{id?}', [ContactController::class, 'delete'])->name('contact_delete');

    Route::get('admin/seo', [SeoController::class, 'show'])->name('seo');
    Route::get('admin/seo/add', [SeoController::class, 'index'])->name('seo_insert');
    Route::get('admin/seo/edit/{id?}', [SeoController::class, 'index'])->name('seo_edit');    
    Route::post('admin/seo/add', [SeoController::class, 'manage_seo_process'])->name('manage_seo_process');
    Route::get('admin/seo/delete/{id?}', [SeoController::class, 'delete'])->name('seo_delete');

    Route::get('admin/web-info', [WebInfoController::class, 'index'])->name('webinfo');    
    Route::post('admin/web-info', [WebInfoController::class, 'manage_webinfo_process'])->name('manage_webinfo_process');

    Route::get('admin/logout', function () {
        session()->forget('ADMIN_LOGIN');
        return redirect('admin');
    });

});



Route::get('/cache', function() {
    Artisan::call('cache:clear');
    return 'Application cache cleared';
});

Route::get('/storage', function() {
    Artisan::call('storage:link');
    return 'Storage linked';
});

Route::get('/view-clear', function() {
    Artisan::call('view:clear');
    return 'View cache has been cleared';
});

