<?php

namespace App\Http\Controllers;

use App\Models\Content;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Storage;

class ContentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id='')
    {
        if($id>0){
            $arr=Content::where(['id'=>$id])->get();
            $result['title']=$arr['0']->title;
            $result['heading']=$arr['0']->heading;
            $result['descr']=$arr['0']->descr;
            $result['image']=$arr['0']->image;

            $result['id']=$arr['0']->id;

        }else {
            $result['title']='';
            $result['heading']='';
            $result['descr']='';
            $result['image']='';

            $result['id']='';

           // $result['home_content']=DB::table('home_contents')->where(['stutas'=>1])->get();
        }
        
        return view('backend/home_content_add',$result);
    }

    public function manage_home_content_process(Request $request)
    {
        // if ($request->post('id')>0) {
        //     $image_validation="mimes:jpg,jpeg,png";
        // }else {
        //     $image_validation="required|mimes:jpg,jpeg,png";
        // }

        $request->validate([
            'title'=>'required',
            // 'image'=>$image_validation,
        ]);
        
        
        if ($request->post('id')>0) {
            $model=Content::find($request->post('id'));
            $msg="Content updated succesfuly";
        }else {
            $model=new Content();
            $msg="Content added succesfuly";
        }
        if ($request->hasfile('image')) {
            if ($request->post('id')>0) {
                $arrImage=DB::table('contents')->where(['id'=>$request->post('id')])->get();
                if (Storage::exists('/public/media/'.$arrImage[0]->image)) {
                    Storage::delete('/public/media/'.$arrImage[0]->image);
                }
            }

            $image=$request->file('image');
            $ext=$image->extension();
            $image_name=time().'.'.$ext;
            $image->storeAs('./public/media', $image_name);
            $model->image=$image_name;
        }
        $model->title=$request->title;
        $model->heading=$request->heading;
        $model->descr=$request->descr;
        $model->stutas=1;
        $model->save();
        if ($model->save()) {
            return redirect()->route('home_contents')->with(['msg'=>$msg]);
        }else {
            return back()->with(['msg'=>'Something went wrong']);
        }
    }

    public function show(Content $content)
    {
        $data['home_contents'] = Content::all();
        return view('backend/home_content', $data);
    }

    public function delete(Request $request){
        $id = $request->id;
        $query = Content::find($id)->delete();
        if ($query) {
            return back()->with(['msg'=>'Content deleted succesfuly']);
        } else {
            return back()->with(['msg'=>'Something went wrong']);
        }
        
    }

    public function stutas(Request $request, $stutas){
        $id = $request->id;
        $query = Content::find($id);
        $query->stutas=$stutas;
        $query->save();
        return back();
    }
}
