<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Storage;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id='')
    {
        if($id>0){
            $arr=Slider::where(['id'=>$id])->get();
            $result['slider_title']=$arr['0']->slider_title;
            $result['slider_heading']=$arr['0']->slider_heading;
            $result['slider_descr']=$arr['0']->slider_descr;
            $result['slider_image']=$arr['0']->slider_image;

            $result['id']=$arr['0']->id;

        }else {
            $result['slider_title']='';
            $result['slider_heading']='';
            $result['slider_descr']='';
            $result['slider_image']='';

            $result['id']='';

        }
        
        return view('backend/slider_add',$result);
    }

    public function manage_slider_process(Request $request)
    {
        if ($request->post('id')>0) {
            $image_validation="mimes:jpg,jpeg,png";
        }else {
            $image_validation="required|mimes:jpg,jpeg,png";
        }

        $request->validate([
            'slider_title'=>'required',
            'slider_image'=>$image_validation,
        ]);
        
        
        if ($request->post('id')>0) {
            $model=Slider::find($request->post('id'));
            $msg="Slider updated succesfuly";
        }else {
            $model=new Slider();
            $msg="Slider added succesfuly";
        }
        if ($request->hasfile('slider_image')) {
            if ($request->post('id')>0) {
                $arrImage=DB::table('sliders')->where(['id'=>$request->post('id')])->get();
                if (Storage::exists('/public/media/slider/'.$arrImage[0]->slider_image)) {
                    Storage::delete('/public/media/slider/'.$arrImage[0]->slider_image);
                }
            }

            $image=$request->file('slider_image');
            $ext=$image->extension();
            $image_name=time().'.'.$ext;
            $image->storeAs('./public/media/slider', $image_name);
            $model->slider_image=$image_name;
        }
        $model->slider_title=$request->slider_title;
        $model->slider_heading=$request->slider_heading;
        $model->slider_descr=$request->slider_descr;
        $model->stutas=1;
        $model->save();
        if ($model->save()) {
            return redirect()->route('sliders')->with(['msg'=>$msg]);
        }else {
            return back()->with(['msg'=>'Something went wrong']);
        }
    }

    public function show(Slider $slider)
    {
        $data['sliders'] = Slider::all();
        return view('backend/slider', $data);
    }

    public function delete(Request $request){
        $id = $request->id;
        $query = Slider::find($id)->delete();
        if ($query) {
            return back()->with(['msg'=>'Slider deleted succesfuly']);
        } else {
            return back()->with(['msg'=>'Something went wrong']);
        }
        
    }

    public function stutas(Request $request, $stutas){
        $id = $request->id;
        $query = Slider::find($id);
        $query->stutas=$stutas;
        $query->save();
        return back();
    }
}
