<?php

namespace App\Http\Controllers;

use App\Models\WebInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Storage;

class WebInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id='')
    {
            $arr=WebInfo::where(['id'=>1])->get();
            $result['abt_descr']=$arr['0']->abt_descr;
            $result['email']=$arr['0']->email;
            $result['phone']=$arr['0']->phone;
            $result['address']=$arr['0']->address;
            $result['logo']=$arr['0']->logo;
            $result['admin_logo']=$arr['0']->admin_logo;
            $result['facebook']=$arr['0']->facebook	;
            $result['twitter']=$arr['0']->twitter;
            $result['instagram']=$arr['0']->instagram;
            $result['google']=$arr['0']->google;

            $result['id']=$arr['0']->id;


        
        return view('backend/webinfo',$result);
    }

    public function manage_webinfo_process(Request $request)
    {
        if ($request->post('id')==1) {
            $image_validation="mimes:jpg,jpeg,png";
        }else {
            $image_validation="required|mimes:jpg,jpeg,png";
        }

        $request->validate([
            'logo'=>$image_validation,
            'admin_logo'=>$image_validation,
        ]);
        
        
        if ($request->post('id')==1) {
            $model=WebInfo::find($request->post('id'));
            $msg="WebInfo updated succesfuly";
        }else {
            $model=new WebInfo();
            $msg="WebInfo added succesfuly";
        }

        if ($request->hasfile('logo')) {
            if ($request->post('id')>0) {
                $arrImage=DB::table('webinfo')->where(['id'=>$request->post('id')])->get();
                if (Storage::exists('/public/media/'.$arrImage[0]->logo)) {
                    Storage::delete('/public/media/'.$arrImage[0]->logo);
                }
            }

            $image=$request->file('logo');
            $ext=$image->extension();
            $image_name=time().rand().'.'.$ext;
            $image->storeAs('./public/media', $image_name);
            $model->logo=$image_name;
        }
        if ($request->hasfile('admin_logo')) {
            if ($request->post('id')>0) {
                $arrImage=DB::table('webinfo')->where(['id'=>$request->post('id')])->get();
                if (Storage::exists('/public/media/'.$arrImage[0]->admin_logo)) {
                    Storage::delete('/public/media/'.$arrImage[0]->admin_logo);
                }
            }

            $admin_logo=$request->file('admin_logo');
            $ext=$admin_logo->extension();
            $admin_logo_name=time().rand().'.'.$ext;
            $admin_logo->storeAs('./public/media', $admin_logo_name);
            $model->admin_logo=$admin_logo_name;
        }
        $model->abt_descr=$request->abt_descr;
        $model->email=$request->email;
        $model->phone=$request->phone;
        $model->address=$request->address;
        $model->facebook=$request->facebook;
        $model->twitter=$request->twitter;
        $model->instagram=$request->instagram;
        $model->google=$request->google;

        $model->save();
        if ($model->save()) {
            return redirect()->route('webinfo')->with(['msg'=>$msg]);
        }else {
            return back()->with(['msg'=>'Something went wrong']);
        }
    }
}
