@extends('frontend/layouts/layout')
@section('title', 'Home')
@section('home_page_active', 'active')
@section('position', 'position-absolute')  {{-- for different navbar style in index page --}}
@section('text', 'text-white')  {{-- for different navbar style in index page --}}
@section('container')

        <!-- ======== SLIDER START ======== -->
        <section class="slider-section">
            <div class="swiper mySwiper">
              <div class="swiper-wrapper position-relative">
                @foreach($sliders as $list)
                <div class="swiper-slide">
                  <img src="{{('storage/media/slider/'.$list->slider_image)}}" alt="">
                  <div class="caption position-absolute text-white text-center">
                    <h2 class="mb-4 h1 fw-bolder">{{$list->slider_heading}}</h2>
                    <p class="text-white-50">
                      @php
                        echo $list->slider_descr;
                      @endphp
                    </p>
                    <div>
                        <a class="btn btn-primary" href="#">GET STARTED</a>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
              <div class="swiper-button-next text-white"></div>
              <div class="swiper-button-prev text-white"></div>
              <div class="swiper-pagination"></div>
            </div>
          </section>
          <!-- ======== /SLIDER END ======== -->

          <section class="section1 py-5 position-relative">
            <div class="container">
              <span class="dot-dot-box"></span>
              <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">Empowering Your Financial Future</h2>
              <div class="row row-cols-1 row-cols-md-3 row-gap-3">
                <div class="col">
                    <div class="card h-100 text-center p-4 border-0 shadow rounded-5 wow fadeInLeft">
                      <div class="card-body">
                        <div class="d-flex align-items-center justify-content-center position-relative">
                          <div class="icon bg-opacity-10" style="background-color: rgba(225,12,26, var(--bs-bg-opacity))"></div>
                          <i class="fa-solid fa-user-check position-absolute" style="color: #e10c1a"></i>
                        </div>
                        <h4 class="card-title my-4 fw-medium">{{$content1[0]->heading}}</h4>
                        <p class="card-text">
                          @php
                            echo $content1[0]->descr;
                          @endphp
                        </p>
                      </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card h-100 text-center p-4 border-0 shadow rounded-5 wow fadeInDown">
                      <div class="card-body">
                        <div class="d-flex align-items-center justify-content-center position-relative">
                          <div class="icon bg-primary bg-opacity-10"></div>
                          <i class="fa-solid fa-hand-holding-heart text-primary position-absolute"></i>
                        </div>
                        <h4 class="card-title my-4 fw-medium">{{$content2[0]->heading}}</h4>
                        <p class="card-text">
                          @php
                            echo $content2[0]->descr;
                          @endphp
                        </p>
                      </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card h-100 text-center p-4 border-0 shadow rounded-5 wow fadeInRight">
                      <div class="card-body">
                        <div class="d-flex align-items-center justify-content-center position-relative">
                          <div class="icon bg-opacity-25" style="background-color: rgba(255,240,0, var(--bs-bg-opacity))"></div>
                          <i class="fa-solid fa-user-tie position-absolute" style="color: #fff000"></i>
                        </div>
                        <h4 class="card-title my-4 fw-medium">{{$content3[0]->heading}}</h4>
                        <p class="card-text">
                          @php
                            echo $content3[0]->descr;
                          @endphp
                        </p>
                      </div>
                    </div>
                </div>
            </div>
            </div>
          </section>

          <!-- ======= consultants section start ======= -->
          <section class="py-5 position-relative overflow-hidden">
            <div class="container">
              <span class="radius-box"></span>
              <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">{{$content4[0]->heading}}</h2>
                <p class="text-dark fw-semibold text-center lh-lg wow zoomIn">
                    @php
                     echo $content4[0]->descr;
                    @endphp
                </p>
            </div>
          </section>
          <!-- ======= /consultants section end ======= -->

          <section class="py-5" style="background-image:linear-gradient(rgba(0,0,0,0.8),rgba(0,0,0,0.8)), url({{asset('frontend/img/clean_home_office_1200x1200.webp')}});background-attachment: fixed;">
            <div class="container">
              <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4 text-white">You Have Money But You Are Financially Weak. Why?</h2>
              <div class="row">
                <div class="col-md-6 mb-4 mb-md-0 wow fadeInLeft">
                  <h2 class="mb-4 fw-semibold text-white">{{$content5[0]->heading}}</h2>
                  <p class="text-white lh-lg">
                    @php
                     echo $content5[0]->descr;
                    @endphp
                  </p>
                </div>
                <div class="col-md-6 wow fadeInRight">
                  <h2 class="mb-4 fw-semibold text-white">{{$content6[0]->heading}}</h2>
                  <p class="text-white lh-lg">
                    @php
                     echo $content6[0]->descr;
                    @endphp
                  </p>
                </div>
              </div>
              <div class="d-flex justify-content-center mt-4">
                <a class="btn btn-primary rounded-0 px-5 py-2 wow zoomIn" href="#">CONTACT US</a>
              </div>
            </div>
          </section>

          <section class="section2 py-5">
            <div class="container">
              <div class="row">
                <div class="col-md-7 order-md-1 mb-4 mb-md-0 wow fadeInRight">
                  <h2 class="fw-semibold">{{$content8[0]->heading}}</h2>
                  <p class="my-4 lh-lg">
                      @php
                        echo $content8[0]->descr;
                      @endphp
                  </p>
                  <a class="btn btn-primary rounded-0 px-5 py-2" href="#">CONTACT US</a>
                </div>
                <div class="col-md-5 wow fadeInLeft">
                  <img class="img-fluid rounded-4 border border-5 border-primary" src="{{asset('storage/media/'.$content8[0]->image)}}" alt="">
                </div>
              </div>
            </div>
          </section>

          <!-- ======== home plan section start ======= -->
          <section class="home-plan-section py-5 bg-body-tertiary">
            <div class="container">
              <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">Plan For Your Future</h2>
              <div class="row row-cols-1 row-cols-md-3 row-gap-5">
                @php
                  $num=0;
                @endphp
                @foreach ($plannings as $list)
                @php
                  $num++;
                  if ($num<10) {
                    $num='0'.$num;
                  }
                @endphp
                <div class="col">
                  <div class="card border-0 rounded-4 py-4 px-2 wow zoomIn">
                    <div class="card-body">
                      <span class="number h1 text-white">{{$num}}</span>
                      <h5 class="fw-semibold my-4">{{$list->title}}</h5>
                      <p class="border-start border-primary border-2 ps-3 text-dark-emphasis fw-semibold mb-5">
                        {{$list->short_descr}}
                      </p>
                      <a class="text-primary fw-semibold" href="/goals">+ Read More</a>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
          </section>
          <!-- ======== /home plan section end ======= -->

          <!-- ======= testimonials section start ======= -->
          <section class="testimonials-section py-5" style="background-image:linear-gradient(rgba(0,0,0,0.8),rgba(0,0,0,0.8)), url({{asset('frontend/img/campaign-creators-gMsnXqILjp4-unsplash.jpg')}});background-size: cover;">
            <!-- <div class="container-fluid mt-5">
              <div class="row row-gap-4">
                <div class="col-md-4">
                  <div class="card h-100 border-0 p-3 rounded-5">
                    <div class="card-body">
                      <i class="fa-solid fa-quote-left text-primary" style="font-size: 3.5rem;"></i>
                      <p class="my-4 lh-base fw-semibold text-black fs-5">
                        Lorem ipsum dolor sit amet, consec
                        tetur adipiscing elit. Pellentesque or
                        nare, magna eu ultricies ornare, nibh
                        leo feugiat diam, at imperdiet justo
                        mauris sed lorem. Morbi a sagittis
                        massa. Morbi a sagittis massa. Maec
                        enas pulvinar, neque a vestibulum
                        dictum, nulla odio suscipit eros, sit
                        amet pharetra tortor metus in ipsum.
                      </p>
                      <div class="d-flex align-items-center">
                        <img class="rounded-circle me-4" src="img/avatar2.jpg" height="55px" width="55px" alt="">
                        <div>
                          <span class="fw-bold text-black">John Doe</span><br>
                          <span class="text-secondary">abc@gmail.com</span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card h-100 border-0 p-3 rounded-5">
                    <div class="card-body">
                      <i class="fa-solid fa-quote-left text-primary" style="font-size: 3.5rem;"></i>
                      <p class="my-4 lh-base fw-semibold text-black fs-5">
                        Lorem ipsum dolor sit amet, consec
                        tetur adipiscing elit. Pellentesque or
                        nare, magna eu ultricies ornare, nibh
                        leo feugiat diam, at imperdiet justo
                        mauris sed lorem. Morbi a sagittis
                        massa. Morbi a sagittis massa. Maec
                        enas pulvinar, neque a vestibulum
                        dictum, nulla odio suscipit eros, sit
                        amet pharetra tortor metus in ipsum.
                      </p>
                      <div class="d-flex align-items-center">
                        <img class="rounded-circle me-4" src="img/avatar2.jpg" height="55px" width="55px" alt="">
                        <div>
                          <span class="fw-bold text-black">John Doe</span><br>
                          <span class="text-secondary">abc@gmail.com</span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card h-100 border-0 p-3 rounded-5">
                    <div class="card-body">
                      <i class="fa-solid fa-quote-left text-primary" style="font-size: 3.5rem;"></i>
                      <p class="my-4 lh-base fw-semibold text-black fs-5">
                        Lorem ipsum dolor sit amet, consec
                        tetur adipiscing elit. Pellentesque or
                        nare, magna eu ultricies ornare, nibh
                        leo feugiat diam, at imperdiet justo
                        mauris sed lorem. Morbi a sagittis
                        massa. Morbi a sagittis massa. Maec
                        enas pulvinar, neque a vestibulum
                        dictum, nulla odio suscipit eros, sit
                        amet pharetra tortor metus in ipsum.
                      </p>
                      <div class="d-flex align-items-center">
                        <img class="rounded-circle me-4" src="img/avatar2.jpg" height="55px" width="55px" alt="">
                        <div>
                          <span class="fw-bold text-black">John Doe</span><br>
                          <span class="text-secondary">abc@gmail.com</span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div> -->

            <div class="swiper mySwiper2 mt-5 pt-4" style="padding-bottom: 7rem;">
              <div class="swiper-wrapper">
                @foreach ($testimonials as $list)
                <div class="swiper-slide">
                  <div class="card h-100 border-0 p-3 rounded-5">
                    <div class="card-body">
                      <i class="fa-solid fa-quote-left text-primary" style="font-size: 3.5rem;"></i>
                      <p class="my-4 lh-lg fw-semibold text-black">
                        {{$list->descr}}
                      </p>
                      <div class="d-flex align-items-center">
                        <img class="rounded-circle me-4" src="{{asset('frontend/img/avatar2.jpg')}}" height="55px" width="55px" alt="">
                        <div>
                          <span class="fw-bold text-black">{{$list->name}}</span><br>
                          <span class="text-secondary">{{$list->post}}</span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
              <div class="swiper-button-next text-white bg-primary rounded-circle"></div>
              <div class="swiper-button-prev text-white bg-primary rounded-circle"></div>
              <div class="swiper-pagination d-none"></div>
            </div>
          </section>
          <!-- ======= /testimonials section end ======= -->

        
@endsection