@extends('frontend/layouts/layout')
@section('title', 'Products')
@section('products_page_active', 'active')
@section('container')

        <!-- ========== BANNER SECTION START ========== -->
        <section class="banner-section position-relative">
            <div class="container">
                <h2 class="position-absolute top-50 text-white fw-bold">OUR PRODUCTS</h2>
            </div>
        </section>
        <!-- ========== /BANNER SECTION END ========== -->


        <!-- ======= products section start ======= -->
        <section class="products-section py-5">
            <div class="container">
                <h2 class="text-center mb-5 fw-semibold position-relative line-after pb-4">How Our Products will Help You</h2>
                @php
                    $k=1;
                @endphp
                @foreach ($products as $list)
                @php
                    $k++;
                    if ($k%2==0) {
                        $order='';
                    } else {
                        $order='order-md-1';
                    }
                @endphp
                <div class="row py-md-5 mb-4 mb-md-0">
                    <div class="col-md-7 {{$order}}">
                        <h4 class="text-center mb-4 fw-semibold position-relative line-after pb-4">{{$list->title}}</h4>
                        <p class="lh-lg">
                            @php
                                echo $list->descr;
                            @endphp
                        </p>
                    </div>
                    <div class="col-md-5">
                        <img class="img-fluid rounded border border-5 border-primary" src="{{asset('storage/media/'.$list->image)}}" alt="">
                    </div>
                </div>
                @endforeach
            </div>
        </section>
        <!-- ======= /products section end ======= -->

@endsection