<?php
  use App\Models\WebInfo;
  use App\Models\Planning;
  
  $webinfo = WebInfo::all();
  $plannings = Planning::limit(5)->get();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- CDN LINKS -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato&family=Noto+Serif+Lao&family=Oswald&family=Poppins&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.2/animate.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/custom.css')); ?>">
</head>
<body>

    <section class="top-section <?php echo $__env->yieldContent('position'); ?>">
      <!-- ======== header start ======= -->
      <header class="d-none d-md-block">
        <div class="container border-bottom border-secondary py-2 px-0">
            <div class="d-flex justify-content-between align-items-center">
                <h6 class="<?php echo $__env->yieldContent('text'); ?>">Lorem ipsum dolor sit amet</h6>
                <div class="<?php echo $__env->yieldContent('text'); ?>">
                    Contact Us &nbsp;|&nbsp; <i class="fa-solid fa-phone"></i> <?php echo e($webinfo[0]->phone); ?>

                </div>
            </div>
        </div>
    </header>
    <!-- ======== /header end ======= -->
    <!-- ======== navbar start ======= -->
    <nav class="navbar navbar-expand-lg">
      <div class="container">
        <a class="navbar-brand fw-bold text-primary fs-1" href="/">
          <img src="<?php echo e(asset('storage/media/'.$webinfo[0]->logo)); ?>" width="80px" alt="">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
            <li class="nav-item me-2 position-relative">
              <a class="nav-link <?php echo $__env->yieldContent('text'); ?> <?php echo $__env->yieldContent('home_page_active'); ?> position-relative" aria-current="page" href="/">Home</a>
            </li>
            <li class="nav-item me-2 position-relative">
              <a class="nav-link <?php echo $__env->yieldContent('text'); ?> <?php echo $__env->yieldContent('goals_page_active'); ?> position-relative" href="/goals">
                Goals
              </a>
              <!-- <ul class="dropdown-menu py-0 border-primary">
                <li><a class="dropdown-item" href="/focus.html">Action</a></li>
                <li><a class="dropdown-item" href="#">Another action</a></li>
                <li><a class="dropdown-item" href="#">Something else here</a></li>
              </ul> -->
            </li>
            <li class="nav-item me-2 position-relative">
              <a class="nav-link <?php echo $__env->yieldContent('text'); ?> <?php echo $__env->yieldContent('about_page_active'); ?> position-relative" href="/about">
                About Us
              </a>
            </li>
            <li class="nav-item">
              <a class="btn btn-outline-primary rounded-5 <?php echo $__env->yieldContent('text'); ?> <?php echo $__env->yieldContent('contact_page_active'); ?>" href="/contact">Contact Us</a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <!-- ======== /navbar end ======= -->
    </section>

    <!-- ========= main contents start ========= -->
    <main class="overflow-hidden">

        <?php $__env->startSection('container'); ?>
        <?php echo $__env->yieldSection(); ?>

    </main>
    <!-- ========= /main contents end ========= -->


    <!-- footer start -->
    <footer class="pt-5 bg-primary">
      <div class="container">
        <div class="row">
          <div class="col-md-3 mb-4 mb-md-0">
            <h3 class="text-success">
            <img src="<?php echo e(asset('storage/media/'.$webinfo[0]->logo)); ?>" width="80px" alt="">
            </h3>
            <p class="my-md-5 my-4 text-white">
              <?php echo e($webinfo[0]->abt_descr); ?>

            </p>
            <div class="social-links">
              <a class="d-inline-block rounded-circle fs-5 me-2 text-center text-white" href="<?php echo e($webinfo[0]->facebook); ?>"><i class="fa-brands fa-facebook-f"></i></a>
              <a class="d-inline-block rounded-circle fs-5 me-2 text-center text-white" href="<?php echo e($webinfo[0]->twitter); ?>"><i class="fa-brands fa-twitter"></i></a>
              <a class="d-inline-block rounded-circle fs-5 me-2 text-center text-white" href="<?php echo e($webinfo[0]->instagram); ?>"><i class="fa-brands fa-instagram"></i></a>
              <a class="d-inline-block rounded-circle fs-5 me-2 text-center text-white" href="<?php echo e($webinfo[0]->google); ?>"><i class="fa-brands fa-youtube"></i></a>
            </div>
          </div>
          <div class="col-md-3 mb-4 mb-md-0">
            <h4 class="text-white mb-4">Links</h4>
            <ul class="list-unstyled">
              <li class="mb-3"><a class="text-white" href="/"><i class="fa-solid fa-square-arrow-up-right text-success"></i>&nbsp;&nbsp;Home</a></li>
              <li class="mb-3"><a class="text-white" href="/about"><i class="fa-solid fa-square-arrow-up-right text-success"></i>&nbsp;&nbsp;About Us</a></li>
              <li class="mb-3"><a class="text-white" href="/goals"><i class="fa-solid fa-square-arrow-up-right text-success"></i>&nbsp;&nbsp;Our Goals</a></li>
              <li class="mb-3"><a class="text-white" href="contact"><i class="fa-solid fa-square-arrow-up-right text-success"></i>&nbsp;&nbsp;Contact Us</a></li>
            </ul>
          </div>
          <div class="col-md-3 mb-4 mb-md-0">
            <h4 class="text-white mb-4">Planning</h4>
            <ul class="list-unstyled">
              <?php $__currentLoopData = $plannings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="mb-3"><a class="text-white" href="/goals"><i class="fa-solid fa-square-arrow-up-right text-success"></i>&nbsp;&nbsp;<?php echo e($list->title); ?></a></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              
            </ul>
          </div>
          <div class="col-md-3">
            <h4 class="text-white mb-4">Contact</h4>
            <ul class="list-unstyled">
              <li class="mb-3">
                <div class="d-flex align-items-center">
                  <i class="fa-solid fa-location-dot me-3 text-success"></i>&nbsp;
                  <a class="text-white ps-0" href="#"><?php echo e($webinfo[0]->address); ?></a>
                </div>
              </li>
              <li class="mb-3"><i class="fa-solid fa-phone me-3 text-success"></i><a class="text-white" href="tel:<?php echo e($webinfo[0]->phone); ?>"><?php echo e($webinfo[0]->phone); ?></a></li>
              <li class="mb-3"><i class="fa-solid fa-envelope me-3 text-success"></i><a class="text-white" href="mailto:<?php echo e($webinfo[0]->email); ?>"><?php echo e($webinfo[0]->email); ?></a></li>
            </ul>
          </div>
        </div>
        <div class="d-flex justify-content-md-between border-top border-2 py-4 flex-column flex-md-row mt-4 text-white">
          <span>&copy; <a class="text-white" href="/">lorem ipsum.</a> All Rights Reserved</span>
          <span>Design & Developed By <a class="text-white fst-italic" href="https://www.bhavitra.com">Bhavitra Technologies</a></span>
        </div>
      </div>
    </footer>
    <!-- /footer end -->

    <!-- ========= SCROLL BTN ======== -->
    <a class="scroll-top-btn position-fixed text-white text-center rounded bg-primary shadow" href="#">
      <i class="fa-solid fa-arrow-up fs-5 text-white lh-base"></i>
    </a>
    


    <script src="https://code.jquery.com/jquery-3.6.3.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/js/all.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
    <script src="<?php echo e(asset('frontend/js/script.js')); ?>"></script>
    <script>
        new WOW().init();
    </script>
</body>
</html><?php /**PATH D:\Tilak\Laravel\investment\resources\views/frontend/layouts/layout.blade.php ENDPATH**/ ?>